//#declare tex_simp = 1
//#declare sky_simp = 1
//#declare floor_tex_simp = 1

#include "DanzTex.inc"
#include "colors.inc"
#include "textures.inc"
#include "glass.inc"
#include "woods.inc"
#include "skies.inc"

#declare Main_Cam = camera{location<0,2.25,-4>look_at<0,1.5,0>}
#declare Cork_Cam = camera{location<-1,1,-2>look_at<0,0,0>}

camera{Main_Cam}

light_source{<-30,30,-50>1}
light_source{<50,10,-40>0.6}
light_source{<-12,100,0>0.4}

#ifdef(floor_tex_simp)
#declare floor_tex =  texture{pigment{rgb 1}}
#else
#declare floor_tex =  texture{T_Wood7 finish{specular 0.15 roughness 0.025 ambient 0.25 reflection 0.15}rotate 90*y rotate<10,0,14>translate -2*x}
#end

#ifdef(tex_simp)
#declare Red_Wine = pigment{rgb x}
#declare Cork_Tex = texture{pigment{rgb 0.5}}
#declare Glass_Tex = texture{pigment{rgb 0.75}}
#declare Bottle_Tex = texture{pigment{rgb z}}
#declare Screw_Tex = texture{pigment{rgb 0.5}}
#declare Screw_Handle_Tex = texture{pigment{rgb z}}
#else
#declare Red_Wine = pigment{rgbf <1,0.1,0.1,0.5> }
#declare Cork_Tex = texture{pigment{bozo pigment_map{[0 rgb<0.918,0.553,0.137>][1 rgb<0.792,0.408,0>]}turbulence 0.04 scale 0.1}normal{crackle 0.25 scale 0.25}}
#declare Glass_Tex = texture{T_Glass3}
#declare Bottle_Tex = texture{T_Winebottle_Glass}
#declare Screw_Tex = texture{KnifeTex}
#declare Screw_Handle_Tex = texture{Stuff}
#end

#ifndef(sky_simp)
sky_sphere{S_Cloud2 rotate 10*x}
#end
background{SkyBlue}

intersection{plane{y,0}plane{z,7}texture{floor_tex}}

#declare spill = sphere{0,1 scale<5,0.1,5>pigment{Red_Wine}}

#declare Glass1 = object {
 sor {
 7,
 <0,0>
 <0.3,0>
 <0.1,0.1>
 <0.1,0.4>
 <0.3,0.6>
 <0.3,1.5>
 <0.3,1.6>
 open
 texture{Glass_Tex}
 }
}

#declare Spill_Glass = sor {
 7,
 <0,0>
 <0.3,0>
 <0.1,0.1>
 <0.1,0.4>
 <0.3,0.6>
 <0.3,1.5>
 <0.3,1.6>
 open
 texture{Glass_Tex}
 translate <-0.5,-2.0,0.35>
 rotate<-90,-80,0>
 }

#declare wine=sor {
5,
<0.1,0.1>
<0.1,0.4>
<0.3,0.6>
<0.3,1.25>
<0.3,1.25>
pigment{Red_Wine}
}


#declare WineBottle =object{
 lathe {
cubic_spline
 15,
 <0,0>
 <0.675,0.00001>
 <0.7,0.05>
 <0.7,2.75>
 <0.3,3.7>
 <0.225,3.925>
 <0.2,4.4>
 <0.2,4.75>
 <0.25,4.75>
 <0.25,4.8>
 <0.2,4.85>
 <0.17,4.9>
 <0.2,4.95>
 <0.15,5.0>
 <0.1448,4.999>
 sturm
 texture{Bottle_Tex}
 scale 0.75
 translate -0.7*y
 }
}

#declare Wine_Glass1 = union{
object {Glass1 translate <-1.2,0,0.7>} //left glass
object {wine translate<-1.2,0.05,0.7>scale <0.9999,1,0.9999>} //wine in the left glass
}

#declare Wine_Glass2 = union{
object {Glass1 translate <1,0,0.2>} //right glass
object {wine translate<1,0.05,0.2>scale <0.9999,1,0.9999>} //wine in the right glass
}

#declare Spills = union{
object{spill translate<0.8,0,-2.0>scale<2,0.2,1>}
object{spill translate<125.8,0,-2.0>scale<0.2,0.02,0.2>}
object{spill translate<50,60,-2.0>scale<0.2,0.02,0.2>}
object{spill translate<58,0,-25.0>scale<0.3,0.03,0.3>}
scale 0.1
}

#declare Cork_Screw = union{
union{
#declare cnt = 0
#declare endcnt = 1000
#declare wrps = 4
#declare len = 4
#declare wid = 0.3
#while(cnt<endcnt)
#declare Prog = cnt/endcnt
sphere{0,0.125 translate wid*y rotate Prog*360*wrps*x translate -Prog*len*x+len/2*x}
#declare cnt = cnt + 1
#end
texture{Screw_Tex}
}
union{
cylinder{-len/2*x+0.4*x,-len/2*x-0.4*x,0.6}
union{
#declare Handle_Len = 3.5
cylinder{-Handle_Len/2*z,Handle_Len/2*z,0.6}
sphere{0,0.6 scale<1,1,0.2>translate -Handle_Len/2*z}
sphere{0,0.6 scale<1,1,0.2>translate Handle_Len/2*z}
scale<0.75,1,1>
translate -len/2*x-0.4*x
}
texture{Screw_Handle_Tex}
}
}

#declare cork =cylinder{0*x,3*x,0.75 texture{Cork_Tex}translate 0.75*y}

#declare CorkAndScrew = union{
object{cork scale 0.2}
object{Cork_Screw scale 0.25 translate 0.75*0.2*y-0.1*x}
scale 0.7
rotate 210*y
translate -0.5*z+0.25*x
}
//---------------------Build the Whole thing.------------------
#declare Scenery = union{
object{Spill_Glass}
object{WineBottle translate<0.4,0.3,1.0>}
object{Spills}
object{Wine_Glass1}
object{Wine_Glass2}
object{CorkAndScrew}
}

object{Scenery}



